{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 23.12.98 - 00:27:21 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, MMWave, MMObj, MMUtils, MMWheel, Mask, ExtCtrls, MMVolume, MMConect,
  MMRingBf, MMWMixer, MMDSPObj, MMWavOut, MMHTimer, MMDesign, MMDIBCv,
  MMLevel, MMCstDlg, MMDSPMtr, MMLEDS, MMACMCvt, MMHook;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Timer: TMMHiTimer;
    btnStop: TButton;
    btnStart: TButton;
    WaveOut: TMMWaveOut;
    WaveMixer: TMMWaveMixer;
    TimeLabel: TLabel;
    RingBuffer: TMMRingBuffer;
    Level1: TMMLevel;
    Connector: TMMConnector;
    Level2: TMMLevel;
    ckbLevel: TCheckBox;
    Label2: TLabel;
    lblDropOuts: TLabel;
    TrackVolume1: TMMVolume;
    Panel1: TPanel;
    Volume1: TMMWheel;
    Label5: TLabel;
    Label6: TLabel;
    Panning1: TMMWheel;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    Label8: TLabel;
    PanningMaster: TMMWheel;
    TrackVolume2: TMMVolume;
    Panel2: TPanel;
    Label11: TLabel;
    Label12: TLabel;
    Volume2: TMMWheel;
    Panning2: TMMWheel;
    Panel3: TPanel;
    Label15: TLabel;
    Label16: TLabel;
    Volume3: TMMWheel;
    Panning3: TMMWheel;
    Panel4: TPanel;
    Label19: TLabel;
    Label20: TLabel;
    Volume4: TMMWheel;
    Panning4: TMMWheel;
    TrackVolume3: TMMVolume;
    TrackVolume4: TMMVolume;
    WaveFile1: TMMWaveFile;
    WaveFile2: TMMWaveFile;
    WaveFile3: TMMWaveFile;
    WaveFile4: TMMWaveFile;
    MasterVolume: TMMVolume;
    OpenDialog: TMMWaveOpenDialog;
    PCMConverter1: TMMPCMConverter;
    PCMConverter2: TMMPCMConverter;
    PCMConverter3: TMMPCMConverter;
    PCMConverter4: TMMPCMConverter;
    ckbLoop1: TCheckBox;
    ckbLoop2: TCheckBox;
    ckbLoop3: TCheckBox;
    ckbLoop4: TCheckBox;
    FilePanel1: TPanel;
    btnFile1: TButton;
    FName1: TLabel;
    Label3: TLabel;
    meStart1: TMaskEdit;
    FilePanel2: TPanel;
    btnFile2: TButton;
    FName2: TLabel;
    Label9: TLabel;
    meStart2: TMaskEdit;
    FilePanel3: TPanel;
    btnFile3: TButton;
    FName3: TLabel;
    Label13: TLabel;
    meStart3: TMaskEdit;
    FilePanel4: TPanel;
    btnFile4: TButton;
    FName4: TLabel;
    Label17: TLabel;
    meStart4: TMaskEdit;
    Label1: TLabel;
    DSPLabel: TLabel;
    LED1: TMMLED;
    LED2: TMMLED;
    LED3: TMMLED;
    LED4: TMMLED;
    Label4: TLabel;
    lblPos4: TLabel;
    Label10: TLabel;
    lblPos3: TLabel;
    Label18: TLabel;
    lblPos2: TLabel;
    Label22: TLabel;
    lblPos1: TLabel;
    DSPMeter: TMMDSPMeter;
    btnReset1: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure ckbLevelClick(Sender: TObject);
    procedure RingBufferEmpty(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure PanningChange(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure PanningMasterChange(Sender: TObject);
    procedure meStartExit(Sender: TObject);
    procedure meStartKeyPress(Sender: TObject; var Key: Char);
    procedure ckbLoopClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnReset1Click(Sender: TObject);
  private
    DropOuts: Longint;
    TimeCounter: Longint;
  public
    procedure UpdateFileLabel(Tag: integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// NOTE: Maximal playbacktime of TMMWaveOut is ~3.5 hours, then it will stop.
//       The Windows MMSystem works with 32 bit positions and they will overflow
//       if the 32 bit value is wrapped so we stop the device. It's always a good
//       idea to close and restart the device every 2-3 hours.
//       This limitation is removed in the Delphi4 version !

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Timer.Enabled := False;
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   TimeCounter := 0;
   Timer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   Timer.Enabled := False;
   DSPLabel.Caption := '0 %';
   LED1.Enabled := False;
   LED2.Enabled := False;
   LED3.Enabled := False;
   LED4.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   DropOuts := 0;
   WaveOut.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TimerTimer(Sender: TObject);
begin
   TimeLabel.Caption := TimeToString64(WaveOut.Position,WaveOut.PositionHigh,True);

   inc(TimeCounter);
   if (Timer.Interval*TimeCounter >= 500) then
   begin
      TimeCounter := 0;
      DSPLabel.Caption := IntToStr(DSPMeter.Value)+' %';

      LED1.Enabled := WaveMixer.InputLoading[0];
      LED2.Enabled := WaveMixer.InputLoading[1];
      LED3.Enabled := WaveMixer.InputLoading[2];
      LED4.Enabled := WaveMixer.InputLoading[3];

      lblPos1.Caption := TimeToString64Ex(WaveMixer.InputPosition[0],True);
      lblPos2.Caption := TimeToString64Ex(WaveMixer.InputPosition[1],True);
      lblPos3.Caption := TimeToString64Ex(WaveMixer.InputPosition[2],True);
      lblPos4.Caption := TimeToString64Ex(WaveMixer.InputPosition[3],True);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RingBufferEmpty(Sender: TObject);
begin
   inc(DropOuts);
   lblDropOuts.Caption := IntToStr(DropOuts);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLevelClick(Sender: TObject);
begin
   Connector.Enabled := ckbLevel.Checked;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.UpdateFileLabel(Tag: integer);
begin
   case Tag of
      0: FName1.Caption := MinimizeName(WaveFile1.Wave.FileName,FName1.Canvas,FName1.Width);
      1: FName2.Caption := MinimizeName(WaveFile2.Wave.FileName,FName2.Canvas,FName2.Width);
      2: FName3.Caption := MinimizeName(WaveFile3.Wave.FileName,FName3.Canvas,FName3.Width);
      3: FName4.Caption := MinimizeName(WaveFile4.Wave.FileName,FName4.Canvas,FName4.Width);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      case TControl(Sender).Tag of
         0: begin
               { mark this channel as done }
               WaveMixer.InputDone[0] := True;
               { set the new filename }
               WaveFile1.Wave.FileName := OpenDialog.FileName;
               { The WaveMixer should play the channel immediately }
               { if the Input has changed }
               WaveMixer.InputDone[0] := False;
            end;
         1: begin
               WaveMixer.InputDone[1] := True;
               WaveFile2.Wave.FileName := OpenDialog.FileName;
               WaveMixer.InputDone[1] := False;
            end;
         2: begin
               WaveMixer.InputDone[2] := True;
               WaveFile3.Wave.FileName := OpenDialog.FileName;
               WaveMixer.InputDone[2] := False;
            end;
         3: begin
               WaveMixer.InputDone[3] := True;
               WaveFile4.Wave.FileName := OpenDialog.FileName;
               WaveMixer.InputDone[3] := False;
            end;
      end;
      UpdateFileLabel(TControl(Sender).Tag);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnReset1Click(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: begin
            { mark this channel as done }
            WaveMixer.InputDone[0] := True;
            { set the new filename }
            WaveFile1.Wave.FileName := '';
         end;
      1: begin
            WaveMixer.InputDone[1] := True;
            WaveFile2.Wave.FileName := '';
         end;
      2: begin
            WaveMixer.InputDone[2] := True;
            WaveFile3.Wave.FileName := '';
         end;
      3: begin
            WaveMixer.InputDone[3] := True;
            WaveFile4.Wave.FileName := '';
         end;
   end;
   UpdateFileLabel(TControl(Sender).Tag);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: TrackVolume1.Volume := Volume1.Value;
      1: TrackVolume2.Volume := Volume2.Value;
      2: TrackVolume3.Volume := Volume3.Value;
      3: TrackVolume4.Volume := Volume4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: TrackVolume1.Panning := Panning1.Value;
      1: TrackVolume2.Panning := Panning2.Value;
      2: TrackVolume3.Panning := Panning3.Value;
      3: TrackVolume4.Panning := Panning4.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.PanningMasterChange(Sender: TObject);
begin
   MasterVolume.Panning := PanningMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.meStartExit(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.StartPos1 := MaskToTime(meStart1.Text);
       1: WaveMixer.StartPos2 := MaskToTime(meStart2.Text);
       2: WaveMixer.StartPos3 := MaskToTime(meStart3.Text);
       3: WaveMixer.StartPos4 := MaskToTime(meStart4.Text);
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.meStartKeyPress(Sender: TObject; var Key: Char);
begin
   if (Key = #13) then TMaskEdit(Sender).OnExit(Sender);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ckbLoopClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: WaveMixer.Loop1 := ckbLoop1.Checked;
       1: WaveMixer.Loop2 := ckbLoop2.Checked;
       2: WaveMixer.Loop3 := ckbLoop3.Checked;
       3: WaveMixer.Loop4 := ckbLoop4.Checked;
   end;
end;

end.
